#pragma once

#include <iostream>
#include <string>
#include <fstream>
#include <filesystem>

using namespace std;
using namespace filesystem;

#define _EPII_FILE_PLUS_HPP_
#if __cplusplus >= 201703L
namespace file_plus {

	bool file_exist(string paths)
	{
		fstream f(paths);
		if (f.good())
		{
			return true;
		}
		return false;
	}

	bool folder_exist(string paths)
	{
		return is_directory(paths);
	}

	string file_read(string paths,int line)
	{
		ifstream f(paths);
		if (!file_exist(paths))
		{
			return "File_Plus_Error:file does not exist!";
		}
		int i = 1;
		string str;
		while (getline(f,str))
		{
			if (i >= line)
			{
				break;
			}
			i++;
		}
		if (i < line)
		{
			return "File_Plus_Error:The document does not have line " + to_string(line) + "!!!";
		}
		return str;
	}

	bool file_new(string paths)
	{
		ofstream f(paths);
		if (f.is_open())
		{
			f.close();
			return true;
		}
		return false;
	}

	bool folder_new(string paths)
	{
		path pt = paths;
		if (file_exist(paths) || folder_exist(paths))
		{
			return false;
		}
		if (!folder_exist(pt.parent_path().string()))
		{
			return false;
		}
		if (!create_directory(paths))
		{
			return false;
		}
		return true;
	}

	bool file_change(string paths,string content)
	{
		if(!file_exist(paths))
		{
			return false;
		}
		fstream f(paths,ios::out);
		if (f.is_open())
		{
			f << content;
			f.close();
			return true;
		}
		return false;
	}

	bool file_delete(string paths)
	{
		if (file_exist(paths))
		{
			remove(paths);
		}
		if (file_exist(paths))
		{
			return false;
		}
		return true;
	}

	bool folder_delete(string paths)
	{
		if (folder_exist(paths))
		{
			remove_all(paths);
		}
		if (folder_exist(paths))
		{
			return false;
		}
		return true;
	}

	string what_os()
	{
#if _WIN32
#if _WIN64
		return "Windows64";
#else
		return "Windows32";
#endif
#elif  __linux__
#if __ANDROID__
		return "Android";
#else
		return "Linux";
#endif
#elif __APPLE__
#if TARGET_OS_IPHONE
		return "IOS";
#elif TARGET_OS_MAC
		return "MacOS";
#else
		return "OtherApple";
#endif
#elif __HARMONYOS__
		return "HarmonyOS";
#else
		return "Other";
#endif
	}

	bool rename_file(string paths,string newname)
	{
		path pt = paths;
		if (!file_exist(paths)&&!folder_exist(paths))
		{
			return false;
		}
		path ls = pt.parent_path() / newname;
		rename(pt, ls);
		if (!file_exist(ls.string())&& !folder_exist(ls.string()))
		{
			return false;
		}
		return true;
	}

	bool move_file(string old_paths, string new_paths)
	{
		if (!file_exist(old_paths) && !folder_exist(new_paths))
		{
			return false;
		}
		rename(old_paths, new_paths);
		if (!file_exist(new_paths) && !folder_exist(new_paths))
		{
			return false;
		}
		return true;
	}

}
#endif
